import 'package:flutter/material.dart';
import 'package:hyip_lab/core/utils/my_color.dart';
import 'package:hyip_lab/core/utils/style.dart';

class FormRow extends StatelessWidget {

  final String label;
  final bool isRequired;

  const FormRow({Key? key,
    required this.label,
    required this.isRequired
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.start,
      children: [
        Text(label,style: interBoldDefault.copyWith(color: MyColor.getTextColor()),),
        Text(isRequired?' *':'',style: interBoldDefault.copyWith(color: MyColor.red),)
      ],
    );
  }
}
